function pasteTldrawContent(editor, clipboard, point) {
  const selectionBoundsBefore = editor.getSelectionPageBounds();
  editor.mark("paste");
  editor.putContentOntoCurrentPage(clipboard, {
    point,
    select: true
  });
  const selectedBoundsAfter = editor.getSelectionPageBounds();
  if (selectionBoundsBefore && selectedBoundsAfter && selectionBoundsBefore?.collides(selectedBoundsAfter)) {
    editor.updateInstanceState({ isChangingStyle: true });
    editor.timers.setTimeout(() => {
      editor.updateInstanceState({ isChangingStyle: false });
    }, 150);
  }
}
export {
  pasteTldrawContent
};
//# sourceMappingURL=pasteTldrawContent.mjs.map
